// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     chrome/browser/media/router/media_router.mojom
//

package org.chromium.mojom.media_router.interfaces;

class MediaRouter_Internal {

    public static final org.chromium.mojo.bindings.Interface.Manager<MediaRouter, MediaRouter.Proxy> MANAGER =
            new org.chromium.mojo.bindings.Interface.Manager<MediaRouter, MediaRouter.Proxy>() {
    
        public String getName() {
            return "media_router::interfaces::MediaRouter";
        }
    
        public int getVersion() {
          return 0;
        }
    
        public Proxy buildProxy(org.chromium.mojo.system.Core core,
                                org.chromium.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }
    
        public Stub buildStub(org.chromium.mojo.system.Core core, MediaRouter impl) {
            return new Stub(core, impl);
        }
    
        public MediaRouter[] buildArray(int size) {
          return new MediaRouter[size];
        }
    };

    private static final int REGISTER_MEDIA_ROUTE_PROVIDER_ORDINAL = 0;
    private static final int ON_SINKS_RECEIVED_ORDINAL = 1;
    private static final int ON_ISSUE_ORDINAL = 2;
    private static final int ON_ROUTES_UPDATED_ORDINAL = 3;

    static final class Proxy extends org.chromium.mojo.bindings.Interface.AbstractProxy implements MediaRouter.Proxy {

        Proxy(org.chromium.mojo.system.Core core,
              org.chromium.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }

        @Override
        public void registerMediaRouteProvider(MediaRouteProvider mediaRouterProvider, RegisterMediaRouteProviderResponse callback) {
            MediaRouterRegisterMediaRouteProviderParams _message = new MediaRouterRegisterMediaRouteProviderParams();
            _message.mediaRouterProvider = mediaRouterProvider;
            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(
                                    REGISTER_MEDIA_ROUTE_PROVIDER_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new MediaRouterRegisterMediaRouteProviderResponseParamsForwardToCallback(callback));
        }

        @Override
        public void onSinksReceived(String mediaSource, MediaSink[] sinks) {
            MediaRouterOnSinksReceivedParams _message = new MediaRouterOnSinksReceivedParams();
            _message.mediaSource = mediaSource;
            _message.sinks = sinks;
            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(ON_SINKS_RECEIVED_ORDINAL)));
        }

        @Override
        public void onIssue(Issue issue) {
            MediaRouterOnIssueParams _message = new MediaRouterOnIssueParams();
            _message.issue = issue;
            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(ON_ISSUE_ORDINAL)));
        }

        @Override
        public void onRoutesUpdated(MediaRoute[] routes) {
            MediaRouterOnRoutesUpdatedParams _message = new MediaRouterOnRoutesUpdatedParams();
            _message.routes = routes;
            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(ON_ROUTES_UPDATED_ORDINAL)));
        }

    }

    static final class Stub extends org.chromium.mojo.bindings.Interface.Stub<MediaRouter> {

        Stub(org.chromium.mojo.system.Core core, MediaRouter impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(org.chromium.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {
                    case org.chromium.mojo.bindings.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return org.chromium.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                MediaRouter_Internal.MANAGER, messageWithHeader);
                    case ON_SINKS_RECEIVED_ORDINAL: {
                        MediaRouterOnSinksReceivedParams data =
                                MediaRouterOnSinksReceivedParams.deserialize(messageWithHeader.getPayload());
                        getImpl().onSinksReceived(data.mediaSource, data.sinks);
                        return true;
                    }
                    case ON_ISSUE_ORDINAL: {
                        MediaRouterOnIssueParams data =
                                MediaRouterOnIssueParams.deserialize(messageWithHeader.getPayload());
                        getImpl().onIssue(data.issue);
                        return true;
                    }
                    case ON_ROUTES_UPDATED_ORDINAL: {
                        MediaRouterOnRoutesUpdatedParams data =
                                MediaRouterOnRoutesUpdatedParams.deserialize(messageWithHeader.getPayload());
                        getImpl().onRoutesUpdated(data.routes);
                        return true;
                    }
                    default:
                        return false;
                }
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(org.chromium.mojo.bindings.Message message, org.chromium.mojo.bindings.MessageReceiver receiver) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {
                    case org.chromium.mojo.bindings.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return org.chromium.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), MediaRouter_Internal.MANAGER, messageWithHeader, receiver);
                    case REGISTER_MEDIA_ROUTE_PROVIDER_ORDINAL: {
                        MediaRouterRegisterMediaRouteProviderParams data =
                                MediaRouterRegisterMediaRouteProviderParams.deserialize(messageWithHeader.getPayload());
                        getImpl().registerMediaRouteProvider(data.mediaRouterProvider, new MediaRouterRegisterMediaRouteProviderResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    default:
                        return false;
                }
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }

    static final class MediaRouterRegisterMediaRouteProviderParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public MediaRouteProvider mediaRouterProvider;
    
        private MediaRouterRegisterMediaRouteProviderParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public MediaRouterRegisterMediaRouteProviderParams() {
            this(0);
        }
    
        public static MediaRouterRegisterMediaRouteProviderParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static MediaRouterRegisterMediaRouteProviderParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            MediaRouterRegisterMediaRouteProviderParams result = new MediaRouterRegisterMediaRouteProviderParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.mediaRouterProvider = decoder0.readServiceInterface(8, false, MediaRouteProvider.MANAGER);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(mediaRouterProvider, 8, false, MediaRouteProvider.MANAGER);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            MediaRouterRegisterMediaRouteProviderParams other = (MediaRouterRegisterMediaRouteProviderParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.mediaRouterProvider, other.mediaRouterProvider))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(mediaRouterProvider);
            return result;
        }
    }

    static final class MediaRouterRegisterMediaRouteProviderResponseParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public String instanceId;
    
        private MediaRouterRegisterMediaRouteProviderResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public MediaRouterRegisterMediaRouteProviderResponseParams() {
            this(0);
        }
    
        public static MediaRouterRegisterMediaRouteProviderResponseParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static MediaRouterRegisterMediaRouteProviderResponseParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            MediaRouterRegisterMediaRouteProviderResponseParams result = new MediaRouterRegisterMediaRouteProviderResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.instanceId = decoder0.readString(8, false);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(instanceId, 8, false);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            MediaRouterRegisterMediaRouteProviderResponseParams other = (MediaRouterRegisterMediaRouteProviderResponseParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.instanceId, other.instanceId))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(instanceId);
            return result;
        }
    }

    static class MediaRouterRegisterMediaRouteProviderResponseParamsForwardToCallback extends org.chromium.mojo.bindings.SideEffectFreeCloseable
            implements org.chromium.mojo.bindings.MessageReceiver {
        private final MediaRouter.RegisterMediaRouteProviderResponse mCallback;

        MediaRouterRegisterMediaRouteProviderResponseParamsForwardToCallback(MediaRouter.RegisterMediaRouteProviderResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(REGISTER_MEDIA_ROUTE_PROVIDER_ORDINAL,
                                           org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }
                MediaRouterRegisterMediaRouteProviderResponseParams response = MediaRouterRegisterMediaRouteProviderResponseParams.deserialize(messageWithHeader.getPayload());
                mCallback.call(response.instanceId);
                return true;
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class MediaRouterRegisterMediaRouteProviderResponseParamsProxyToResponder implements MediaRouter.RegisterMediaRouteProviderResponse {

        private final org.chromium.mojo.system.Core mCore;
        private final org.chromium.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        MediaRouterRegisterMediaRouteProviderResponseParamsProxyToResponder(
                org.chromium.mojo.system.Core core,
                org.chromium.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(String instanceId) {
            MediaRouterRegisterMediaRouteProviderResponseParams _response = new MediaRouterRegisterMediaRouteProviderResponseParams();
            _response.instanceId = instanceId;
            org.chromium.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new org.chromium.mojo.bindings.MessageHeader(
                                    REGISTER_MEDIA_ROUTE_PROVIDER_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }

    static final class MediaRouterOnSinksReceivedParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 24;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(24, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public String mediaSource;
        public MediaSink[] sinks;
    
        private MediaRouterOnSinksReceivedParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public MediaRouterOnSinksReceivedParams() {
            this(0);
        }
    
        public static MediaRouterOnSinksReceivedParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static MediaRouterOnSinksReceivedParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            MediaRouterOnSinksReceivedParams result = new MediaRouterOnSinksReceivedParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.mediaSource = decoder0.readString(8, false);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                {
                    org.chromium.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(org.chromium.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    result.sinks = new MediaSink[si1.elementsOrVersion];
                    for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                        org.chromium.mojo.bindings.Decoder decoder2 = decoder1.readPointer(org.chromium.mojo.bindings.DataHeader.HEADER_SIZE + org.chromium.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                        result.sinks[i1] = MediaSink.decode(decoder2);
                    }
                }
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(mediaSource, 8, false);
            if (sinks == null) {
                encoder0.encodeNullPointer(16, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(sinks.length, 16, org.chromium.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < sinks.length; ++i0) {
                    encoder1.encode(sinks[i0], org.chromium.mojo.bindings.DataHeader.HEADER_SIZE + org.chromium.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            MediaRouterOnSinksReceivedParams other = (MediaRouterOnSinksReceivedParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.mediaSource, other.mediaSource))
                return false;
            if (!java.util.Arrays.deepEquals(this.sinks, other.sinks))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(mediaSource);
            result = prime * result + java.util.Arrays.deepHashCode(sinks);
            return result;
        }
    }

    static final class MediaRouterOnIssueParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public Issue issue;
    
        private MediaRouterOnIssueParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public MediaRouterOnIssueParams() {
            this(0);
        }
    
        public static MediaRouterOnIssueParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static MediaRouterOnIssueParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            MediaRouterOnIssueParams result = new MediaRouterOnIssueParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                result.issue = Issue.decode(decoder1);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(issue, 8, false);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            MediaRouterOnIssueParams other = (MediaRouterOnIssueParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.issue, other.issue))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(issue);
            return result;
        }
    }

    static final class MediaRouterOnRoutesUpdatedParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public MediaRoute[] routes;
    
        private MediaRouterOnRoutesUpdatedParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public MediaRouterOnRoutesUpdatedParams() {
            this(0);
        }
    
        public static MediaRouterOnRoutesUpdatedParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static MediaRouterOnRoutesUpdatedParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            MediaRouterOnRoutesUpdatedParams result = new MediaRouterOnRoutesUpdatedParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                {
                    org.chromium.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(org.chromium.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    result.routes = new MediaRoute[si1.elementsOrVersion];
                    for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                        org.chromium.mojo.bindings.Decoder decoder2 = decoder1.readPointer(org.chromium.mojo.bindings.DataHeader.HEADER_SIZE + org.chromium.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                        result.routes[i1] = MediaRoute.decode(decoder2);
                    }
                }
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            if (routes == null) {
                encoder0.encodeNullPointer(8, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(routes.length, 8, org.chromium.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < routes.length; ++i0) {
                    encoder1.encode(routes[i0], org.chromium.mojo.bindings.DataHeader.HEADER_SIZE + org.chromium.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            MediaRouterOnRoutesUpdatedParams other = (MediaRouterOnRoutesUpdatedParams) object;
            if (!java.util.Arrays.deepEquals(this.routes, other.routes))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + java.util.Arrays.deepHashCode(routes);
            return result;
        }
    }

}

